% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_inset_frame.R
\name{geom_inset_frame}
\alias{geom_inset_frame}
\title{Add a frame and burst lines for an inset.}
\usage{
geom_inset_frame(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "sf",
  position = "identity",
  ...,
  inset = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.}
}
\value{
A ggplot layer holding the inset frame.
}
\description{
Add a frame and burst lines for an inset.
}
\section{Controlling aesthetics}{

Aesthetic mappings or parameters can be provided. They can be scalars, or
vectors of length 4 (times the number of panels when faceting) corresponding
in order to the source circle, target circle, then the two line segments
connecting them, respectively. Note that the connecting lines might not be
drawn if the inset and original circle overlap, which will affect the count.
}

\examples{
library(sf)
library(ggplot2)

cfg <- configure_inset(
  centre = st_sfc(st_point(c(-82, 35)), crs = 4326),
  scale = 2,
  translation = c(0, -300),
  radius = 50,
  units = "mi")

ggplot() + geom_inset_frame(inset = cfg) + coord_sf()
}
