% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trek.R
\name{trek}
\alias{trek}
\title{Grab a trek from Google}
\usage{
trek(from, to, mode = c("driving", "walking", "bicycling", "transit"),
  output = c("simple", "all"), alternatives = FALSE,
  units = "metric", urlonly = FALSE, override_limit = FALSE,
  ext = "com", inject = "", ...)
}
\arguments{
\item{from}{name of origin addresses in a data frame}

\item{to}{name of destination addresses in a data frame}

\item{mode}{driving, bicycling, walking, or transit}

\item{output}{amount of output ("simple" or "all")}

\item{alternatives}{should more than one route be provided?}

\item{units}{"metric"}

\item{urlonly}{return only the url?}

\item{override_limit}{override the current query count}

\item{ext}{domain extension (e.g. "com", "co.nz")}

\item{inject}{character string to add to the url}

\item{...}{...}
}
\value{
a tibble
}
\description{
Sequence treks (latitude-longitude sequences following ordinary paths, e.g.
roads) between two locations using the Google Directions API. Note: To use
Google's Directions API, you must first enable the API in the Google Cloud
Platform Console. See \code{?register_google}.
}
\examples{

\dontrun{ requires Google API key, see ?register_google

## basic usage
########################################

from <- "houston, texas"
to <- "waco, texas"

(route_df <- route(from, to, structure = "route"))
(trek_df  <-  trek(from, to, structure = "route"))

qmap("college station, texas", zoom = 8) +
  geom_path(
    aes(x = lon, y = lat),  colour = "red",
    size = 1.5, alpha = .5,
    data = route_df, lineend = "round"
  ) +
  geom_path(
    aes(x = lon, y = lat),  colour = "blue",
    size = 1.5, alpha = .5,
    data = trek_df, lineend = "round"
  )



from <- "rice university houston texas"
to <- "1001 Bissonnet St, Houston, TX 77005"
trek_df <- trek(from, to)
qmplot(lon, lat, data = trek_df, geom = "path", maptype = "terrain",
  color = I("red"), size = I(2), alpha = I(.5)
)

trek_df <- trek(from, to, mode = "walking")
qmplot(lon, lat, data = trek_df, geom = "path", maptype = "terrain",
  color = I("red"), size = I(2), alpha = I(.5)
)

trek_df <- trek(from, to, mode = "transit")
qmplot(lon, lat, data = trek_df, geom = "path", maptype = "terrain",
  color = I("red"), size = I(2), alpha = I(.5)
)



## neat faceting example
########################################

from <- "houston, texas"; to <- "waco, texas"
trek_df <- trek(from, to, alternatives = TRUE)

qmplot(lon, lat, data = trek_df, geom = "path",
  color = route, size = I(2), maptype = "terrain",
  alpha = I(.5)
)

qmplot(lon, lat, data = trek_df, geom = "path",
  color = route, size = I(2), maptype = "terrain",
  zoom = 8
) + facet_grid(. ~ route)




}

}
\seealso{
\url{https://developers.google.com/maps/documentation/directions/},
  \url{http://stackoverflow.com/questions/30270011/ggmap-route-finding-doesnt-stay-on-roads},
   \code{\link{route}}, \code{\link{routeQueryCheck}}
  \code{\link{register_google}}
}
\author{
David Kahle \email{david.kahle@gmail.com} with the key decoding
  algorithm due to Stack Overflow user akhmed
}
