% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\alias{mutate_geocode}
\alias{geocodeQueryCheck}
\title{Geocode}
\usage{
geocode(location, output = c("latlon", "latlona", "more", "all"),
  source = c("google", "dsk"), force = ifelse(source == "dsk", FALSE,
  TRUE), urlonly = FALSE, override_limit = FALSE,
  nameType = c("long", "short"), ext = "com", inject = "", ...)

mutate_geocode(data, location, ...)

geocodeQueryCheck()
}
\arguments{
\item{location}{a character vector of street addresses or place names (e.g.
"1600 pennsylvania avenue, washington dc" or "Baylor University")}

\item{output}{amount of output, "latlon", "latlona", "more", or "all"}

\item{source}{"google" for Google (note: "dsk" is defunct)}

\item{force}{force online query, even if cached (previously downloaded)}

\item{urlonly}{return only the url?}

\item{override_limit}{override the current query rate}

\item{nameType}{in some cases, Google returns both a long name and a short
name. this parameter allows the user to specify which to grab.}

\item{ext}{top level domain (e.g. "com", "co.nz"); helpful for non-US users}

\item{inject}{character string to add to the url or named character vector of
key-value pairs to be injected (e.g. c("a" = "b") get converted to "a=b"
and appended to the query)}

\item{...}{...}

\item{data}{a data frame or equivalent}
}
\value{
If \code{output} is "latlon", "latlona", or "more", a tibble (classed
  data frame). If "all", a list.
}
\description{
Geocodes (finds latitude and longitude of) a location using the Google
Geocoding API. Note: To use Google's Geocoding API, you must first enable the
API in the Google Cloud Platform Console. See \code{?register_google}.
}
\examples{

\dontrun{ requires Google API key, see ?register_google

## basic usage
########################################

# geocoding is most commonly used for addresses
geocode("1600 Amphitheatre Parkway, Mountain View, CA")
geocode("1600 Amphitheatre Parkway, Mountain View, CA", urlonly = TRUE)

# google can also geocode colloquial names of places
geocode("the white house")

# geocode can also accept character vectors of places
geocode(c("the white house", "washington dc"))



## types of output
########################################

geocode("waco texas")
geocode("waco texas", output = "latlona")
geocode("waco texas", output = "more")
str(geocode("waco texas", output = "all"))

geocode(c("waco, texas", "houston, texas"))
geocode(c("waco, texas", "houston, texas"), output = "latlona")
geocode(c("waco, texas", "houston, texas"), output = "all") \%>\% str(4)



## mutate_geocode
########################################

# mutate_geocode is used to add location columns to an existing dataset
# that has location information

df <- data.frame(
  address = c("1600 Pennsylvania Avenue, Washington DC", "", "houston texas"),
  stringsAsFactors = FALSE
)

mutate_geocode(df, address)
df \%>\% mutate_geocode(address)


## known issues
########################################

# in some cases geocode finds several locations
geocode("waco city hall")


}


}
\seealso{
\url{http://code.google.com/apis/maps/documentation/geocoding/},
  \url{https://developers.google.com/maps/documentation/javascript/geocoding},
  \url{https://developers.google.com/maps/documentation/geocoding/usage-limits}
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
