% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggChoropleth.R
\name{ggChoropleth}
\alias{ggChoropleth}
\title{Draw an interactive choropleth map}
\usage{
ggChoropleth(data, mapping, map, colors = c("white", "orange", "red"),
  palette = NULL, title = "", digits = 1, interactive = FALSE, ...)
}
\arguments{
\item{data}{a data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_. Passed on geom_map_interactive. Required mappings are map_id and fill. Possible mapping is facet.}

\item{map}{a map maybe a result of map_data()}

\item{colors}{A vector of colours used as a parameter of scale_fill_gradientn()}

\item{palette}{A palette name used for discrete fill var}

\item{title}{A title}

\item{digits}{An integer indicating the number of decimal places}

\item{interactive}{Logical. If positive an interactive map will be made}

\item{...}{other arguments passed on to geom_map_interactive}
}
\description{
Draw an interactive choropleth map
}
\examples{
#crimes <- data.frame(state = tolower(rownames(USArrests)), USArrests)
#require(ggplot2)
#require(ggiraph)
#require(maps)
#require(mapproj)
#states_map <- map_data("state")
#ggChoropleth(crimes,aes(fill=Murder,map_id=state),map=states_map,interactive=TRUE)
#ggChoropleth(crimes,aes(fill=c(Murder,Rape),map_id=state),map=states_map,interactive=TRUE)
#ggChoropleth(crimes,aes(map_id=state),map=states_map,interactive=TRUE)
}

