% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_options.R
\name{opts_sizing}
\alias{opts_sizing}
\title{Girafe sizing settings}
\usage{
opts_sizing(rescale = TRUE, width = 1)
}
\arguments{
\item{rescale}{if FALSE, graphic will not be resized
and the dimensions are exactly those of the container.}

\item{width}{widget width ratio (0 < width <= 1).}
}
\description{
Allows customization of the svg style sizing
}
\examples{
library(ggplot2)

dataset <- mtcars
dataset$carname = row.names(mtcars)

gg <- ggplot(
  data = dataset,
  mapping = aes(x = wt, y = qsec, color = disp,
                tooltip = carname, data_id = carname) ) +
  geom_point_interactive() + theme_minimal()

x <- girafe(ggobj = gg)
x <- girafe_options(x,
  opts_sizing(rescale = FALSE) )
if( interactive() ) print(x)
}
\seealso{
Other girafe animation options: 
\code{\link{girafe_options}()},
\code{\link{opts_hover}()},
\code{\link{opts_selection}()},
\code{\link{opts_toolbar}()},
\code{\link{opts_tooltip}()},
\code{\link{opts_zoom}()}
}
\concept{girafe animation options}
