% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghighlight.R
\name{gghighlight}
\alias{gghighlight}
\title{Highlight Data With Predicate}
\usage{
gghighlight(..., n = NULL, max_highlight = 5L,
  unhighlighted_colour = ggplot2::alpha("grey", 0.7), use_group_by = NULL,
  use_direct_label = NULL, label_key = NULL, label_params = list(fill =
  "white"))
}
\arguments{
\item{...}{Expressions to filter data, which is passed to \code{\link[dplyr:filter]{dplyr::filter()}}.}

\item{n}{Number of layers to clone.}

\item{max_highlight}{Max number of series to highlight.}

\item{unhighlighted_colour}{Colour for unhighlighted geoms.}

\item{use_group_by}{If \code{TRUE}, use \code{\link[dplyr:group_by]{dplyr::group_by()}} to evaluate \code{predicate}.}

\item{use_direct_label}{If \code{TRUE}, add labels directly on the plot instead of using a legend.}

\item{label_key}{Column name for \code{label} aesthetics.}

\item{label_params}{A list of parameters, which is passed to \code{\link[ggrepel:geom_label_repel]{ggrepel::geom_label_repel()}}.}
}
\description{
\code{gghiglight()} highlights (almost) any geoms according to the given predicates.
}
\examples{
d <- data.frame(
  idx = c( 1, 1, 1, 2, 2, 2, 3, 3, 3),
  value = c( 1, 2, 3,10,11,12, 9,10,11),
  category = rep(c("a","b","c"), 3),
  stringsAsFactors = FALSE
)

# highlight the lines whose max values are larger than 10
ggplot(d, aes(idx, value, colour = category)) +
  geom_line() + gghighlight(max(value) > 10)

# highlight the points whose values are larger than 10
ggplot(d, aes(idx, value)) +
  geom_point() +
  gghighlight(value > 10, label_key = category)

}
