% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_basis.R
\name{autoplot.basis}
\alias{autoplot.basis}
\title{Autoplot spline basis instances}
\usage{
\method{autoplot}{basis}(object, data, n = 256, ...)
}
\arguments{
\item{object}{spline basis object}

\item{data}{x-values at which to evaluate the splines. Optional. By
default, an evenly spaced sequence of 256 values covering the
range of the splines will be used.}

\item{n}{If data is not provided, instead use an evenly-spaced
sequence of x-values of this length (plus one, since both
endpoints are included). If data is provided, this argument is
ignored.}

\item{...}{Ignored.}
}
\value{
ggplot
}
\description{
Autoplot spline basis instances
}
\examples{
library(splines)
x <- seq(0, 1, by=0.001)
spl <- bs(x, df=6)
autoplot(spl)
autoplot(spl, n=5)
}
