% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_smooth}
\alias{gf_smooth}
\alias{gf_lm}
\title{Formula interface to geom_smooth()}
\usage{
gf_smooth(object = NULL, gformula = NULL, data = NULL, method = "auto",
  formula = y ~ x, se = TRUE, method.args, n = 80, span = 0.75,
  fullrange = FALSE, level = 0.95, xlab, ylab, title, subtitle, caption,
  geom = "smooth", stat = "smooth", position = "identity",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), ...)

gf_lm(object = NULL, gformula = NULL, data = NULL, alpha = 0.3,
  lm.args = list(), interval = "none", level = 0.95, fullrange = TRUE,
  xlab, ylab, title, subtitle, caption, geom = "lm", stat = "lm",
  position = "identity", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{method}{smoothing method (function) to use, eg. "lm", "glm",
  "gam", "loess", "rlm".

  For \code{method = "auto"} the smoothing method is chosen based on the
  size of the largest group (across all panels). \code{\link{loess}} is
  used for than 1,000 observations; otherwise \code{\link[mgcv]{gam}} is
  used with \code{formula = y ~ s(x, bs = "cs")}. Somewhat anecdotally,
  \code{loess} gives a better appearance, but is O(n^2) in memory, so does
  not work for larger datasets.}

\item{formula}{formula to use in smoothing function, eg. \code{y ~ x},
\code{y ~ poly(x, 2)}, \code{y ~ log(x)}}

\item{se}{display confidence interval around smooth? (TRUE by default, see
level to control}

\item{method.args}{List of additional arguments passed on to the modelling
function defined by \code{method}.}

\item{n}{number of points to evaluate smoother at}

\item{span}{Controls the amount of smoothing for the default loess smoother.
Smaller numbers produce wigglier lines, larger numbers produce smoother
lines.}

\item{fullrange}{should the fit span the full range of the plot, or just
the data}

\item{level}{level of confidence interval to use (0.95 by default)}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{lm.args}{A list of arguments to \code{\link[stats:lm]{stats::lm()}}.}

\item{interval}{One of \code{"none"}, \code{"confidence"} or \code{"prediction"}.}
}
\value{
a gg object
}
\description{
LOESS and linear model smoothers in \code{ggformula}.
}
\details{
Positional aesthetics are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\examples{
gf_smooth()
gf_lm()
if (require(mosaicData)) {
  gf_smooth(births ~ date, color = ~wday, data = Births78)
  gf_smooth(births ~ date, color = ~wday, data = Births78, fullrange = TRUE)
  gf_smooth(births ~ date, color = ~wday, data = Births78, show.legend = FALSE, se = FALSE)
  gf_lm(length ~ width, data = KidsFeet, color = ~biggerfoot, alpha = 0.2) \%>\%
    gf_point()
  gf_lm(length ~ width, data = KidsFeet, color = ~biggerfoot, fullrange = FALSE, alpha = 0.2)
    gf_point()
  gf_lm(length ~ width, color = ~ sex, data = KidsFeet,
        formula = y ~ poly(x,2), linetype = "dashed") \%>\%
    gf_point()
  gf_lm(length ~ width, color = ~ sex, data = KidsFeet,
        formula = log(y) ~ x, backtrans = exp) \%>\%
    gf_point()
}
gf_lm(hwy ~ displ, data = mpg,
      formula = log(y) ~ poly(x,3), backtrans = exp,
     interval = "prediction", fill = "skyblue") \%>\%
  gf_lm(
     formula = log(y) ~ poly(x,3), backtrans = exp,
     interval = "confidence", color = "red") \%>\%
  gf_point()

}
\seealso{
\code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}}, \code{\link[=gf_spline]{gf_spline()}}
}
