% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{ggformula}
\alias{ggformula}
\title{Formula interface to ggplot2}
\description{
The functions in \pkg{ggformula} provide a formula interface to \code{ggplot2} layer
functions and a system for working with pipes to create multi-layer
plots and to refine plots.
For plots with just one layer, the formula interface
is more compact than native \pkg{ggplot2} code and is consistent with modeling
functions like \code{\link{lm}()} that use a formula interface and with the
numerical summary functions in the \pkg{mosaic} package.
}
\details{
Positional aesthetics are typically specified using a formula (see the \code{gformula} argument).
Setting and mapping of additional attributes can be done within the formula or
through the use of additional arguments.  The latter is considered preferable.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.
Additional formula terms of the form \code{+ attribute::value} map \code{attribute}
to \code{value}; terms of the form \code{+ attribute:value} will map
\code{attribute} to \code{value} if \code{value} is the name of a variable in
\code{data}, else \code{attribute} will be set to the constant \code{value}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link{facet_wrap}()} or \code{\link{facet_grid}()}.
This provides an alternative to \code{\link{gf_facet_wrap}()} and
\code{\link{gf_facet_grid}()} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\examples{
apropos("gf_")
gf_point()
}
