% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{getDegree}
\alias{getDegree}
\title{Determine the degree between two varieties}
\usage{
getDegree(v1, v2, ig, geneal)
}
\arguments{
  \item{v1}{the label of the first variety/vertex of
  interest (in character string format)}

  \item{v2}{the label of the second variety/vertex of
  interest (in character string format)}

  \item{ig}{the graph representation of the data genealogy
  (in igraph format)}

  \item{geneal}{the full genealogy (in data frame format)}
}
\description{
Returns the degree (distance between unweighted edges)
between two varieties, where an edge represents a
parent-child relationship
}
\examples{
data(sbGeneal)
ig = dfToIG(sbGeneal)
getDegree("Brim","Bedford",ig,sbGeneal)
}

