% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggalleffects.R
\name{ggalleffects}
\alias{ggalleffects}
\title{Get marginal effects for all model predictors}
\usage{
ggalleffects(model, terms = NULL, ci.lvl = 0.95, ...)
}
\arguments{
\item{model}{A fitted model object, or a list of model objects. Any model
that is supported by the \CRANpkg{effects}-package should work.}

\item{terms}{Character vector with term names of selected variables from
\code{model}, which should be used to compute marginal effects.
If \code{terms = NULL}, marginal effects for all model terms are
returned.}

\item{ci.lvl}{Numeric, the level of the confidence intervals. For \code{ggpredict()},
use \code{ci.lvl = NA}, if confidence intervals should not be calculated
(for instance, due to computation time).}

\item{...}{Further arguments passed down to \code{\link[effects]{allEffects}}.}
}
\value{
A list of tibbles (with \code{ggeffects} class attribute) with consistent
          data columns. The list contains one tibble per model term. Columns are:
        \describe{
          \item{\code{x}}{the values of the model predictor to which the effect pertains, used as x-position in plots.}
          \item{\code{predicted}}{the predicted values, used as y-position in plots.}
          \item{\code{conf.low}}{the lower bound of the confidence interval for the predicted values.}
          \item{\code{conf.high}}{the upper bound of the confidence interval for the predicted values.}
        }
}
\description{
\code{ggalleffects()} computes marginal effects of model terms.
               It internally calls \code{\link[effects]{allEffects}} and
               puts the result into tidy data frames.
}
\note{
Interaction effects are not included in the return value, i.e. \code{ggalleffects()}
      does not compute marginal effects for interaction terms. Use \code{\link{gginteraction}}
      to create tidy data frames especially for interaction terms.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)
ggalleffects(fit)

library(ggplot2)
fit <- lm(barthtot ~ c12hour + neg_c_7 + c160age, data = efc)
mydf <- get_complete_df(ggalleffects(fit))

ggplot(mydf, aes(x, predicted)) +
  geom_line() +
  facet_wrap(~group, scale = "free_x", ncol = 1)

}
