% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{simulate.model}
\alias{simulate.model}
\title{Simulate response time data}
\usage{
\method{simulate}{model}(object, nsim = NA, seed = NULL, nsub = NA,
  prior = NA, ps = NA, ...)
}
\arguments{
\item{object}{a model object.}

\item{nsim}{number of trials / responses. \code{n} can be a single number
for a balanced design or a matrix for an unbalanced design, where rows
are subjects and columns are design cells. If the matrix has one row then
all subjects have the same \code{n} in each cell, if it has one column then
all cells have the same \code{n}; Otherwise each entry specifies the
\code{n} for a particular subject x design cell combination.}

\item{seed}{a user specified random seed.}

\item{nsub}{number of subjects}

\item{prior}{a prior object}

\item{ps}{a true parameter vector or matrix.}

\item{...}{additional optional arguments.}
}
\value{
a data frame
}
\description{
Simulate response time data either for one subject or multiple subjects.
The simulation is based on a model object. For one subject, one must supply
a true parameter vector to the \code{ps} argument.
}
\details{
For multiple subjects, one can enter a matrix (or a row vector) as true
parameters. Each row is to generate data separately for a subject.  This is
the fixed-effect model. To generate data based on a random-effect
model, one must supply a prior object.  In this case, \code{ps} argument
is unused. Note in some cases, a random-effect model may fail to draw data
from the model, because true parameters are randomly drawn from
a prior object.  This would happen sometimes in diffusion model, because
certain parameter combinations are considered invalid.

\code{ps} can be a row vector, in which case each subject has identical
parameters.  It can also be a matrix with one row per subject, in which
case it must have \code{ns} rows. The true values will be saved as
\code{parameters} attribute in the output object.
}
