% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cellIdx2Mat}
\alias{cellIdx2Mat}
\title{Convert cell index list to a matrix}
\usage{
cellIdx2Mat(data)
}
\arguments{
\item{data}{a model data instance}
}
\value{
a matrix
}
\description{
Convert cell index list to a matrix. This is a convenient function.
}
\examples{
m1 <- BuildModel(
    p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1",t0="1",st0="1"),
    match.map = list(M=list(s1="r1", s2="r2")),
    factors   = list(S=c("s1", "s2")),
    constants = c(st0=0, d=0),
    responses = c("r1","r2"),
    type      = "rd")
p.prior <- BuildPrior(
    dists = rep("tnorm", 6),
    p1    = c(a=2,  v=2.5, z=.5, sz=.3, sv=1,  t0=.3),
    p2    = c(a=.5, v=.5,  z=.1, sz=.1, sv=.3, t0=.05),
    lower = c(0,-5, 0, 0, 0, 0),
    upper = c(5, 7, 2, 2, 2, 2))
dat <- simulate(m1, nsim = 4, prior = p.prior)
dmi <- BuildDMI(dat, m1)
cellIdx2Mat(dmi)
}
