% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PickChains}
\alias{PickChains}
\alias{GetSubchains}
\alias{SelectEmigrants}
\title{Draw n other chains and shuffle them}
\usage{
PickChains(k, nchain, chains)

GetSubchains(nchain)

SelectEmigrants(ngroup, k)
}
\arguments{
\item{k}{the kth processed chain. Must be an integer within the range of 0
to \code{nchain - 1}. No check for errorly using R index.}

\item{nchain}{number of chains to draw.}

\item{chains}{an integer vector, indicating chain index, e.g., 0:23}

\item{ngroup}{number of distributed groups}
}
\value{
a column vector
}
\description{
This is part of DE-MCMC algorithm. \code{PickChains} draws \code{n}
chains out of \code{length(chains)} chains, excluding the kth chain.
\code{GetSubchains} is used in \code{migration} operator. It draws a subset
of chains in \code{nchain} chains.
}
\details{
\code{Getsubchains} is part of the Migration algroithms. It does two-step
shuffling. In step 1, it selects a number l (integer) uniformly between 1
and k to be the number of subpopulations for migration.  In step 2, it
generates the chain index (0 to nchain - 1) and lastely it shuffles them
}
\examples{
chains <- 0:23

## Presuming current processing chain is the 1st chain (C index = 0)
## pick 2 chains out of 24 chains, excluding current chain.
PickChains(0, 2, chains)

## Example outputs
##      [,1]
## [1,]   17
## [2,]   12
##      [,1]
## [1,]    2
## [2,]    5
##      [,1]
## [1,]    5
## [2,]    3
##      [,1]
## [1,]   10
## [2,]    8
##      [,1]
## [1,]   15
## [2,]    8

## get a random number of subchains
GetSubchains(24)
##       [,1]
##  [1,]    0
##  [2,]    3
##  [3,]    5
##  [4,]    9
##  [5,]   10
##  [6,]   12
##  [7,]   14
##  [8,]   15
##  [9,]   18
## [10,]   20
## [11,]   21
## [12,]   22

}
\keyword{PickChains,}
\keyword{getsubchains}
