% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{post_int}
\alias{post_int}
\title{Posterior intervals}
\usage{
post_int(x, mid = c("median", "mean", "mode"), int = c("hdi", "ci"),
  widths = c(0.5, 0.95), adj = 1.5, rope = NULL, warn = FALSE)
}
\arguments{
\item{x}{Vector of numeric values. Typically a posterior sample.}

\item{mid}{Central tendency estimator. Defaults to \code{"median"}. Other options
include \code{"mean"} and \code{"mode"}.}

\item{int}{interval type, either "hdi" or "ci"}

\item{widths}{interval widths}

\item{adj}{Bandwidth adjustment used only with the \code{"mode"} estimator. See
\link{dmode}.}

\item{rope}{Region of practical equivalence. Check how much of the
distribution is within rope value.}

\item{warn}{Turn off warning for flat intervals found (multiple possible
values)}
}
\value{
data.table
}
\description{
Returns cutoff points from a posterior distribution
}
\examples{
x <- rpois(5000, 15)
ints <- post_int(x, warn = FALSE)
hist(x, br=50)
abline(v=ints$c, col="cyan")
abline(v=ints[, c("l.wide", "r.wide")], col="magenta")

post_int(x, "median", warn = FALSE)
post_int(x, "mean", warn = FALSE)
post_int(x, "mode", adj=2, rope = c(14, 16), warn = FALSE)
}
