% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounder.R
\name{bounder_cdf}
\alias{bounder_cdf}
\title{Estimate bounds of a distribution using the CDF of its order statistics}
\usage{
bounder_cdf(x, p = 0.01)
}
\arguments{
\item{x}{numeric vector containing a sample to estimate the bounds of.}

\item{p}{scalar in \eqn{[0,1]}: percentile of the order statistic distribution to use
as the estimate. \code{p = 1} will return \code{range(x)}; \code{p = 0.5} will give the median
estimate, \code{p = 0} will give a very wide estimate (effectively treating the
distribution as unbounded when used with \code{\link[=density_bounded]{density_bounded()}}).}
}
\value{
A length-2 numeric vector giving an estimate of the minimum and maximum bounds
of the distribution that \code{x} came from.
}
\description{
Estimate the bounds of the distribution a sample came from using the CDF of
the order statistics of the sample. Use with the \code{bounder} argument to \code{\link[=density_bounded]{density_bounded()}}.
Supports \link[=automatic-partial-functions]{automatic partial function application}.
}
\details{
\code{\link[=bounder_cdf]{bounder_cdf()}} uses the distribution of the order statistics of
\eqn{X} to estimate where the first and last order statistics (i.e. the
min and max) of this distribution would be, assuming the sample \code{x} is the
distribution. Then, it adjusts the boundary outwards from \code{min(x)} (or \code{max(x)})
by the distance between \code{min(x)} (or \code{max(x)}) and the nearest estimated
order statistic.

Taking \eqn{X} = \code{x}, the distributions of the first and last order statistics are:

\deqn{\begin{array}{rcl}
F_{X_{(1)}}(x) &=& 1 - \left[1 - F_X(x)\right]^n\\
F_{X_{(n)}}(x) &=& F_X(x)^n
\end{array}}

Re-arranging, we can get the inverse CDFs (quantile functions) of each
order statistic in terms of the quantile function of \eqn{X} (which we
can estimate from the data), giving us an estimate for the minimum
and maximum order statistic:

\deqn{\begin{array}{rcrcl}
\hat{x_1} &=& F_{X_{(1)}}^{-1}(p) &=& F_X^{-1}\left[1 - (1 - p)^{1/n}\right]\\
\hat{x_n} &=& F_{X_{(n)}}^{-1}(p) &=& F_X^{-1}\left[p^{1/n}\right]
\end{array}}

Then the estimated bounds are:

\deqn{\left[2\min(x) - \hat{x_1}, 2\max(x) - \hat{x_n} \right]}

These bounds depend on \eqn{p}, the percentile of the distribution of the order
statistic used to form the estimate. While \eqn{p = 0.5} (the median) might be
a reasonable choice (and gives results similar to \code{\link[=bounder_cooke]{bounder_cooke()}}), this tends
to be a bit too aggressive in "detecting" bounded distributions, especially in
small sample sizes. Thus, we use a default of \eqn{p = 0.01}, which tends to
be very conservative in small samples (in that it usually gives results
roughly equivalent to an unbounded distribution), but which still performs
well on bounded distributions when sample sizes are larger (in the thousands).
}
\seealso{
The \code{bounder} argument to \code{\link[=density_bounded]{density_bounded()}}.

Other bounds estimators: 
\code{\link{bounder_cooke}()},
\code{\link{bounder_range}()}
}
\concept{bounds estimators}
