% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_rampbar.R
\name{guide_rampbar}
\alias{guide_rampbar}
\title{Continuous colour ramp guide}
\usage{
guide_rampbar(
  ...,
  to = "gray65",
  available_aes = c("fill_ramp", "colour_ramp")
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:guide_colourbar]{ggplot2::guide_colourbar}}
  \describe{
    \item{\code{title}}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}
    \item{\code{title.position}}{A character string indicating the position of a
title. One of "top" (default for a vertical guide), "bottom", "left"
(default for a horizontal guide), or "right."}
    \item{\code{title.theme}}{A theme object for rendering the title text. Usually the
object of \code{\link[ggplot2:element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link[ggplot2:theme]{theme()}} or theme.}
    \item{\code{title.hjust}}{A number specifying horizontal justification of the
title text.}
    \item{\code{title.vjust}}{A number specifying vertical justification of the title
text.}
    \item{\code{label}}{logical. If \code{TRUE} then the labels are drawn. If
\code{FALSE} then the labels are invisible.}
    \item{\code{label.position}}{A character string indicating the position of a
label. One of "top", "bottom" (default for horizontal guide), "left", or
"right" (default for vertical guide).}
    \item{\code{label.theme}}{A theme object for rendering the label text. Usually the
object of \code{\link[ggplot2:element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.text} in \code{\link[ggplot2:theme]{theme()}}.}
    \item{\code{label.hjust}}{A numeric specifying horizontal justification of the
label text.}
    \item{\code{label.vjust}}{A numeric specifying vertical justification of the label
text.}
    \item{\code{barwidth}}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the width of the colourbar. Default value is \code{legend.key.width} or
\code{legend.key.size} in \code{\link[ggplot2:theme]{theme()}} or theme.}
    \item{\code{barheight}}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the height of the colourbar. Default value is \code{legend.key.height} or
\code{legend.key.size} in \code{\link[ggplot2:theme]{theme()}} or theme.}
    \item{\code{nbin}}{A numeric specifying the number of bins for drawing the
colourbar. A smoother colourbar results from a larger value.}
    \item{\code{raster}}{A logical. If \code{TRUE} then the colourbar is rendered as a
raster object. If \code{FALSE} then the colourbar is rendered as a set of
rectangles. Note that not all graphics devices are capable of rendering
raster image.}
    \item{\code{frame.colour}}{A string specifying the colour of the frame
drawn around the bar. If \code{NULL} (the default), no frame is drawn.}
    \item{\code{frame.linewidth}}{A numeric specifying the width of the frame
drawn around the bar.}
    \item{\code{frame.linetype}}{A numeric specifying the linetype of the frame
drawn around the bar.}
    \item{\code{ticks}}{A logical specifying if tick marks on the colourbar should be
visible.}
    \item{\code{ticks.colour}}{A string specifying the colour of the tick marks.}
    \item{\code{ticks.linewidth}}{A numeric specifying the width of the tick marks.}
    \item{\code{draw.ulim}}{A logical specifying if the upper limit tick marks should
be visible.}
    \item{\code{draw.llim}}{A logical specifying if the lower limit tick marks should
be visible.}
    \item{\code{direction}}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}
    \item{\code{default.unit}}{A character string indicating \code{\link[grid:unit]{grid::unit()}}
for \code{barwidth} and \code{barheight}.}
    \item{\code{reverse}}{logical. If \code{TRUE} the colourbar is reversed. By default,
the highest value is on the top and the lowest value is on the bottom}
    \item{\code{order}}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}
  }}

\item{to}{The color to ramp to in the guide. Corresponds to \code{1} on the scale.}

\item{available_aes}{A vector of character strings listing the aesthetics for which a \code{guide_rampbar()} can be drawn.}
}
\value{
A guide object.
}
\description{
A colour ramp bar guide that shows continuous colour ramp scales mapped onto
values as a smooth gradient. Designed for use with \code{\link[=scale_fill_ramp_continuous]{scale_fill_ramp_continuous()}}
and \code{\link[=scale_colour_ramp_continuous]{scale_colour_ramp_continuous()}}. Based on \code{\link[=guide_colourbar]{guide_colourbar()}}.
}
\details{
This guide creates smooth gradient color bars for use with \code{\link[=scale_fill_ramp_continuous]{scale_fill_ramp_continuous()}}
and \code{\link[=scale_colour_ramp_continuous]{scale_colour_ramp_continuous()}}. The color to ramp from is determined by the \code{from}
argument of the \verb{scale_*} function, and the color to ramp to is determined by the \code{to} argument
to \code{\link[=guide_rampbar]{guide_rampbar()}}.

Guides can be specified in each \verb{scale_*} function or in \code{guides()}.
\code{guide = "rampbar"} in \verb{scale_*} is syntactic sugar for \code{guide = guide_rampbar()};
e.g. \code{scale_colour_ramp_continuous(guide = "rampbar")}. For how to specify
the guide for each scale in more detail, see \code{guides()}.
}
\examples{

library(dplyr)
library(ggplot2)
library(distributional)

# The default guide for ramp scales is guide_legend(), which creates a
# discrete style scale:
tibble(d = dist_uniform(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = stat(x)), fill = "blue") +
  scale_fill_ramp_continuous(from = "red")

# We can guide_rampbar() to instead create a continuous guide, but
# it does not know what ccolor to ramp to (defaults to "gray65"):
tibble(d = dist_uniform(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = stat(x)), fill = "blue") +
  scale_fill_ramp_continuous(from = "red", guide = guide_rampbar())

# We can tell the guide what color to ramp to using the `to` argument:
tibble(d = dist_uniform(0, 1)) \%>\%
  ggplot(aes(y = 0, xdist = d)) +
  stat_slab(aes(fill_ramp = stat(x)), fill = "blue") +
  scale_fill_ramp_continuous(from = "red", guide = guide_rampbar(to = "blue"))

}
\seealso{
\code{\link[=scale_fill_ramp_continuous]{scale_fill_ramp_continuous()}}, \code{\link[=scale_colour_ramp_continuous]{scale_colour_ramp_continuous()}}.
}
\author{
Matthew Kay
}
