% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instrumental.R
\name{Instrumental Variables}
\alias{Instrumental Variables}
\alias{node_instrumental}
\alias{ggdag_instrumental}
\title{Find Instrumental Variables}
\usage{
node_instrumental(.dag, exposure = NULL, outcome = NULL, ...)

ggdag_instrumental(
  .tdy_dag,
  exposure = NULL,
  outcome = NULL,
  ...,
  node_size = 16,
  text_size = 3.88,
  label_size = text_size,
  text_col = "white",
  label_col = text_col,
  node = TRUE,
  stylized = FALSE,
  text = TRUE,
  use_labels = NULL
)
}
\arguments{
\item{.dag, .tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{exposure}{character vector of length 1, name of exposure variable.
Default is \code{NULL}, in which case it will check the input DAG for
exposure.}

\item{outcome}{character vector of length 1, name of exposure variable.
Default is \code{NULL}, in which case it will check the input DAG for
exposure.}

\item{...}{additional arguments passed to \code{tidy_dagitty()}}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{color of label text}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_repel_label()}.
Default is \code{NULL}.}
}
\value{
a \code{tidy_dagitty} with an \code{instrumental} column for
instrumental variables or a \code{ggplot}
}
\description{
\code{node_instrumental} tags instrumental variables given an exposure and
outcome. \code{ggdag_instrumental} plots all instrumental variables. See
\code{\link[dagitty:instrumentalVariables]{dagitty::instrumentalVariables()}} for details.
}
\examples{
library(dagitty)

node_instrumental(dagitty("dag{ i->x->y; x<->y }"), "x", "y")
ggdag_instrumental(dagitty("dag{ i->x->y; i2->x->y; x<->y }"), "x", "y")

}
