% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{Pathways}
\alias{Pathways}
\alias{dag_paths}
\alias{ggdag_paths}
\alias{ggdag_paths_fan}
\title{Find Pathways Between Variables}
\usage{
dag_paths(.dag, from = NULL, to = NULL, adjust_for = NULL,
  directed = FALSE, paths_only = FALSE, ...)

ggdag_paths(.tdy_dag, from = NULL, to = NULL, adjust_for = NULL,
  directed = FALSE, paths_only = FALSE, ..., node_size = 16,
  text_size = 3.88, label_size = text_size, text_col = "white",
  label_col = text_col, node = TRUE, stylized = TRUE, text = TRUE,
  use_labels = NULL)

ggdag_paths_fan(.tdy_dag, from = NULL, to = NULL, adjust_for = NULL,
  directed = FALSE, ..., spread = 0.7, node_size = 16, text_size = 2,
  label_size = text_size, text_col = "white", label_col = text_col,
  node = TRUE, stylized = TRUE, text = TRUE, use_labels = NULL)
}
\arguments{
\item{.dag, .tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{from}{character vector of length 1, name of exposure variable. Default
is \code{NULL}, in which case it will check the input DAG for exposure.}

\item{to}{character vector of length 1, name of exposure variable. Default is
\code{NULL}, in which case it will check the input DAG for exposure.}

\item{adjust_for}{character vector, a set of variables to control for.
Default is \code{NULL}.}

\item{directed}{logical. Should only directed paths be shown?}

\item{paths_only}{logical. Should only open paths be returned? Default is
\code{FALSE}, which includes every variable and edge in the DAG regardless
if they are part of the path.}

\item{...}{additional arguments passed to \code{tidy_dagitty()}}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{label color}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_repel_label()}.
Default is \code{NULL}.}

\item{spread}{the width of the fan spread}
}
\value{
a \code{tidy_dagitty} with a \code{path} column for path variables
and a \code{set} grouping column or a \code{ggplot}
}
\description{
\code{node_paths} finds the pathways between a given exposure and outcome.
\code{ggdag_paths} plots all pathways. See \code{\link[dagitty:paths]{dagitty::paths()}} for details.
}
\examples{
confounder_triangle(x_y_associated = TRUE) \%>\%
  ggdag_paths(from = "x", to = "y")

}
