% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend-draw-ggarchery.R
\name{draw_key_arrowpath}
\alias{draw_key_arrowpath}
\title{This function replaces \code{\link[ggplot2:draw_key]{ggplot2::draw_key_path}} and displays all the requested arrowheads.}
\usage{
draw_key_arrowpath(data, params, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
A grid grob.
}
\description{
This function replaces \code{\link[ggplot2:draw_key]{ggplot2::draw_key_path}} and displays all the requested arrowheads.
}
\examples{

 library(ggplot2)
 library(magrittr)
 library(tidyr)

 # Generate some dummy data

 ten.points <- data.frame(line.no = rep(1:5, each = 2), x = runif(10), y = runif(10),
                          position = rep(c("start", "end"), 5))
 five.segments <- ten.points \%>\% pivot_wider(names_from = position, values_from = c(x,y))

 ggplot(five.segments) +
    geom_point(data = ten.points, aes(x = x, y = y)) +
    geom_segment(aes(x = x_start, xend = x_end, y = y_start, yend = y_end), arrow = arrow(),
                 key_glyph = draw_key_arrowpath)

}
