% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-flow.r
\name{stat_flow}
\alias{stat_flow}
\title{Flow positions}
\usage{
stat_flow(mapping = NULL, data = NULL, geom = "flow",
  position = "identity", decreasing = NA, reverse = TRUE,
  aes.bind = FALSE, na.rm = FALSE, show.legend = NA, inherit.aes = TRUE,
  ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{The geometric object to use display the data;
override the default.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{decreasing}{Logical; whether to arrange the strata at each axis
in the order of the variable values (\code{NA}, the default),
in ascending order of total weight (largest on top, \code{FALSE}), or
in descending order of total weight (largest on bottom, \code{TRUE}).}

\item{reverse}{Logical; if \code{decreasing} is \code{NA},
whether to arrange the strata at each axis
in the reverse order of the variable values,
so that they match the order of the values in the legend.
Ignored if \code{decreasing} is not \code{NA}.
Defaults to \code{TRUE}.}

\item{aes.bind}{Whether to prioritize aesthetics before axes (other than the
index axis) when ordering the lodes within each stratum. Defaults to FALSE.}

\item{na.rm}{Logical:
if \code{FALSE}, the default, \code{NA} lodes are not included;
if \code{TRUE}, \code{NA} lodes constitute a separate category,
plotted in grey (regardless of the color scheme).}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2]{layer}}.}
}
\description{
Given a dataset with alluvial structure, \code{stat_flow} calculates the
centroids (\code{x} and \code{y}) and weights (heights; \code{ymin} and
\code{ymax}) of alluvial flows between each pair of adjacent axes.
}
\section{Aesthetics}{

\code{stat_flow} requires one of two sets of aesthetics:
\itemize{
  \item \code{x}, \code{alluvium}, and (optionally) \code{stratum}
  \item any number of \code{axis[0-9]*} (\code{axis1}, \code{axis2}, etc.)
}
Use \code{x}, \code{alluvium}, and \code{stratum} for data in lodes format
and \code{axis[0-9]*} for data in alluvia format
(see \code{\link{is_alluvial}}).
Arguments to parameters inconsistent with the format will be ignored.
Additionally, \code{stat_flow} accepts the following optional aesthetics:
\itemize{
  \item \code{weight}
  \item \code{group}
}
\code{weight} controls the vertical dimensions of the alluvia
and are aggregated across equivalent observations.
\code{group} is used internally; arguments are ignored.
}

\examples{
# illustrate positioning
ggplot(as.data.frame(Titanic),
       aes(weight = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age,
           color = Survived)) +
  stat_stratum(geom = "errorbar") +
  geom_line(stat = "flow") +
  stat_flow(geom = "pointrange") +
  geom_text(stat = "stratum", label.strata = TRUE) +
  scale_x_continuous(breaks = 1:3,
                     labels = c("Class", "Sex", "Age"))

# use of lode controls
ggplot(as.data.frame(Titanic),
       aes(weight = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age)) +
  geom_flow(aes(fill = Survived), aes.bind = TRUE, reverse = FALSE) +
  geom_stratum(reverse = FALSE) +
  geom_text(stat = "stratum", label.strata = TRUE, reverse = FALSE) +
  scale_x_continuous(breaks = 1:3, labels = c("Class", "Sex", "Age"))

data(vaccinations)
# rightward alluvial aesthetics for vaccine survey data
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           weight = freq, fill = response)) +
  geom_flow(stat = "alluvium", lode.guidance = "rightward") +
  geom_stratum(alpha = .5) +
  geom_text(aes(label = response), stat = "stratum")
# memoryless flows for vaccine survey data
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           weight = freq, fill = response)) +
  geom_flow() +
  geom_stratum(alpha = .5) +
  geom_text(aes(label = response), stat = "stratum")

# aesthetics that vary betwween and within strata
data(vaccinations)
vaccinations$subgroup <- LETTERS[1:2][rbinom(
  n = length(unique(vaccinations$subject)), size = 1, prob = .5
) + 1][vaccinations$subject]
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           weight = freq, fill = response, label = response)) +
  geom_flow(aes(alpha = subgroup)) +
  scale_alpha_discrete(range = c(1/3, 2/3)) +
  geom_stratum(alpha = .5) +
  geom_text(stat = "stratum")

# can even set aesthetics that vary both ways
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           weight = freq, label = response)) +
  geom_flow(aes(fill = interaction(response, subgroup)), aes.bind = TRUE) +
  scale_alpha_discrete(range = c(1/3, 2/3)) +
  geom_stratum(alpha = .5) +
  geom_text(stat = "stratum")
}
\seealso{
\code{\link[ggplot2]{layer}} for additional arguments,
  \code{\link{geom_flow}} for the corresponding geom, and
  \code{\link{stat_stratum}} and \code{\link{geom_stratum}} for
  intra-axis boxes.
}
