% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-chain-stack-switch.R
\name{stack_switch}
\alias{stack_switch}
\alias{stack_active}
\title{Determine the active context of stack layout}
\usage{
stack_switch(sizes = NULL, what = waiver(), ...)

stack_active(sizes = NULL, ...)
}
\arguments{
\item{sizes}{A numeric value or a \code{\link[grid:unit]{unit}} object. When used for
the \code{\link[=quad_layout]{quad_layout()}} annotation, it must be of length \code{1}. When used in the
\code{\link[=stack_layout]{stack_layout()}} with a nested \code{\link[=quad_layout]{quad_layout()}}, it should be of length
\code{3}, specifying the relative heights (for \code{direction = "h"}) or widths (for
\code{direction = "v"}) to be applied to the layout.}

\item{what}{What should get activated for the stack layout?
A single number or string of the plot elements in the layout. If \code{NULL}, will remove any active context, this is useful when the active context is a
\code{\link[=quad_layout]{quad_layout()}} object, where any \verb{align_*()} will be added to the
\code{\link[=quad_layout]{quad_layout()}}. By removing the active context, we can add \verb{align_*()}
into the \code{\link[=stack_layout]{stack_layout()}}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A \code{stack_switch} object which can be added to \code{\link[=stack_layout]{stack_layout()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{stack_active} is an alias for \code{stack_switch()}, which sets \code{what = NULL} by
default.
}
\examples{
stack_discrete("h", matrix(1:9, nrow = 3L)) +
    ggheatmap() +
    # ggheamtap will set the active context, directing following addition
    # into the heatmap plot area. To remove the heatmap active context,
    # we can use `stack_active()` which will direct subsequent addition into
    # the stack
    stack_active() +
    # here we add a dendrogram to the stack.
    align_dendro()
}
