% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmark.R
\name{ggmark}
\alias{ggmark}
\title{Add a plot to annotate selected observations}
\usage{
ggmark(
  mark,
  data = waiver(),
  mapping = aes(),
  ...,
  group1 = NULL,
  group2 = NULL,
  obs_size = 1,
  size = NULL,
  active = NULL
)
}
\arguments{
\item{mark}{A \code{\link[=mark_draw]{mark_draw()}} object to define how to draw the links. Like
\code{\link[=mark_line]{mark_line()}}, \code{\link[=mark_tetragon]{mark_tetragon()}}. Note the names of the pair links will
be used to define the panel names so must be unique.}

\item{data}{The following options can be used:
\itemize{
\item \code{NULL}: No data is set.
\item \code{\link[ggplot2:waiver]{waiver()}}: Inherits the data from the layout matrix.
\item A \code{function} (including purrr-like lambda syntax): Applied to the layout
matrix to transform the data before use. To transform the final plot
data, please use \code{\link[=scheme_data]{scheme_data()}}.
\item A \code{matrix}, \code{data.frame}, or atomic vector.
}}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\code{\link[=fortify_data_frame]{fortify_data_frame()}}.}

\item{group1, group2}{A single boolean value indicating whether to use the
panel group information from the layout as the paired groups. By default,
if no specific observations are selected in \code{mark}, \code{ggmark()} will
automatically connect all observations and group them according to the
layout's defined groups.}

\item{obs_size}{A single numeric value that indicates the size of a single
observation, ranging from \verb{(0, 1]}.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
Add a plot to annotate selected observations
}
\section{ggplot2 specification}{

\code{ggmark} initializes a ggplot object. The underlying data is created using
\code{\link[=fortify_data_frame]{fortify_data_frame()}}. Please refer to it for more details.

In addition, the following columns will be added to the data frame:
\itemize{
\item \code{.panel}: the panel for the aligned axis. It means \code{x-axis} for vertical
stack layout (including top and bottom annotation), \code{y-axis} for
horizontal stack layout (including left and right annotation).
\item \code{.names} (\code{\link[vctrs:vec_names]{vec_names()}}) and \code{.index}
(\code{\link[vctrs:vec_size]{vec_size()}}/\code{\link[=NROW]{NROW()}}): a character names (only
applicable when names exists) and an integer of index of the original
data.
\item \code{.hand}: A factor with levels \code{c("left", "right")} for horizontal stack
layouts, or \code{c("top", "bottom")} for vertical stack layouts, indicating
the position of the linked observations.
}
}

\examples{
set.seed(123)
small_mat <- matrix(rnorm(56), nrow = 7)
rownames(small_mat) <- paste0("row", seq_len(nrow(small_mat)))
colnames(small_mat) <- paste0("column", seq_len(ncol(small_mat)))

# mark_line
ggheatmap(small_mat) +
    theme(axis.text.x = element_text(hjust = 0, angle = -60)) +
    anno_right() +
    align_kmeans(3L) +
    ggmark(mark_line(I(1:3) ~ NULL)) +
    geom_boxplot(aes(.names, value)) +
    theme(plot.margin = margin(l = 0.1, t = 0.1, unit = "npc"))

# mark_tetragon
ggheatmap(small_mat) +
    theme(axis.text.x = element_text(hjust = 0, angle = -60)) +
    anno_right() +
    align_kmeans(3L) +
    ggmark(mark_tetragon(I(1:3) ~ NULL)) +
    geom_boxplot(aes(.names, value)) +
    theme(plot.margin = margin(l = 0.1, t = 0.1, unit = "npc"))
}
