% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-dendrogram.R
\name{align_dendro}
\alias{align_dendro}
\title{Reorder or Group layout based on hierarchical clustering}
\usage{
align_dendro(
  mapping = aes(),
  ...,
  distance = "euclidean",
  method = "complete",
  use_missing = "pairwise.complete.obs",
  reorder_group = FALSE,
  k = NULL,
  h = NULL,
  plot_dendrogram = TRUE,
  plot_cut_height = NULL,
  root = NULL,
  center = FALSE,
  type = "rectangle",
  size = NULL,
  data = NULL,
  free_labs = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  set_context = TRUE,
  order = NULL,
  name = NULL
)
}
\arguments{
\item{mapping}{Additional default list of aesthetic mappings to use for plot.}

\item{...}{Additional arguments passed to
\link[ggplot2:geom_segment]{geom_segment()}.}

\item{distance}{A string of distance measure to be used. This must be one of
\code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or
\code{"minkowski"}.  Correlation coefficient can be also used, including
\code{"pearson"}, \code{"spearman"} or \code{"kendall"}. In this way, \code{1 - cor} will be used
as the distance. In addition, you can also provide a \link[stats:dist]{dist}
object directly or a function return a \link[stats:dist]{dist} object.}

\item{method}{A string of the agglomeration method to be used. This should be
(an unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC). you can also provide a function which
returns a \link[stats:hclust]{hclust} object.}

\item{use_missing}{An optional character string giving a method for computing
covariances in the presence of missing values. This must be (an abbreviation
of) one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
\code{"na.or.complete"}, or \code{"pairwise.complete.obs"}. Only used when \code{distance}
is a correlation coefficient string.}

\item{reorder_group}{A single boolean value, indicates whether we should do
Hierarchical Clustering between groups, only used when previous groups have
been established.}

\item{k}{An integer scalar indicates the desired number of groups.}

\item{h}{A numeric scalar indicates heights where the tree should be cut.}

\item{plot_dendrogram}{A boolean value indicates whether plot the dendrogram
tree.}

\item{plot_cut_height}{A boolean value indicates whether plot the cut height.}

\item{root}{A length one string or numeric indicates the root branch.}

\item{center}{A boolean value. if \code{TRUE}, nodes are plotted centered with
respect to the leaves in the branch. Otherwise (default), plot them in the
middle of all direct child nodes.}

\item{type}{A string indicates the plot type, \code{"rectangle"} or \code{"triangle"}.}

\item{size}{Plot size, can be an \link[grid:unit]{unit} object.}

\item{data}{A matrix, a data frame, or even a simple vector that will be
converted into a one-column matrix. If the \code{data} argument is set to \code{NULL},
the \verb{align_*} will use the \code{layout} data. Additionally, the \code{data} argument
can also accept a function (purrr-like lambda is also okay), which will be
applied with the \code{layout} data,

It is important to note that all \verb{align_*} functions consider the \code{rows} as
the observations. It means the \code{NROW(data)} must return the same number with
the parallel \code{layout} axis.
\itemize{
\item \code{layout_heatmap}: for column annotation, the \code{layout} data will be
transposed before using (If data is a \code{function}, it will be applied with
the transposed matrix). This is necessary because column annotation uses
heatmap columns as observations, but we need rows.
\item \code{layout_stack}: the \code{layout} data will be used as it is since we place all
plots along a single axis.
}}

\item{free_labs}{A boolean value or a string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"} indicates which axis title should be free from
alignment. If \code{NULL}, all axis title will be aligned. Default: "tlbr".}

\item{free_spaces}{A character specifies the ggplot elements which won't
count space sizes when alignment. If \code{NULL} (default), no space will be
removed. See \code{\link[=free_space]{free_space()}} for allowed values.}

\item{plot_data}{A function used to transform the plot data before rendering.
By default, it'll inherit from the parent layout. If no parent layout, the
default is to not modify the data. Use \code{NULL}, if you don't want to modify
anything.

Used to modify the data after layout has been created, but before the data is
handled of to the ggplot2 for rendering. Use this hook if the you needs
change the default data for all \code{geoms}.}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{order}{An single integer for the layout order.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A new \code{Align} object.
}
\description{
Reorder or Group layout based on hierarchical clustering
}
\section{ggplot2 specification}{

\code{align_dendro} initializes a \code{ggplot} data and \code{mapping}.

The internal will always use a default mapping of \code{aes(x = .data$x, y = .data$y)}.

The default ggplot data is the \code{node} coordinates, in addition, a
\link[ggplot2:geom_segment]{geom_segment} layer with a data of the tree segments
\code{edge} coordinates will be added.

\code{node} and tree segments \code{edge} coordinates contains following columns:
\itemize{
\item \code{index}: the original index in the tree for the current node
\item \code{label}: node label text
\item \code{x} and \code{y}: x-axis and y-axis coordinates for current node or the start
node of the current edge.
\item \code{xend} and \code{yend}: the x-axis and y-axis coordinates of the terminal node
for current edge.
\item \code{branch}: which branch current node or edge is. You can use this column
to color different groups.
\item \code{panel}: which panel current node is, if we split the plot into panel
using \link[ggplot2:facet_grid]{facet_grid}, this column will show
which panel current node or edge is from. Note: some nodes may
fall outside panel (between two panel), so there are possible
\code{NA} values in this column. We also provide \code{.panel} column,
which always give the right branch for usage of the ggplot
facet.
\item \code{.panel}: See \code{panel}, this is what we often used.
\item \code{panel1} and \code{panel2}: The panel1 and panel2 variables have the same
functionality as \code{panel}, but they are specifically for the \code{edge} data
and correspond to both nodes of each edge.
\item \code{leaf}: A logical value indicates whether current node is a leaf.
}
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    align_dendro()
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    align_dendro(k = 3L)
}
\seealso{
\itemize{
\item \code{\link[=dendrogram_data]{dendrogram_data()}}
\item \code{\link[=hclust2]{hclust2()}}
}
}
