% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nelson.R
\name{nelson}
\alias{nelson}
\title{nonparametric Nelson-Aalen estimates}
\usage{
nelson(interval, censor, data, by = NULL, weight = NULL, ...)
}
\arguments{
\item{interval}{name of the interval variable in the training dataset.}

\item{censor}{name of the censoring variable in the training dataset.}

\item{data}{name of the survival training data.frame}

\item{by}{stratifying variable in the training dataset, defaults to NULL}

\item{weight}{for each observation (default=NULL)}

\item{...}{arguments passed to the \code{survfit} function}
}
\value{
\code{\link{gg_survival}} object
}
\description{
nonparametric Nelson-Aalen estimates
}
\examples{
\dontrun{
# These get run through the gg_survival examples.
data(pbc, package="randomForestSRC")
pbc$time <- pbc$days/364.25

# This is the same as gg_survival
gg_dta <- nelson(interval="time", censor="status", 
                     data=pbc)
                     
plot(gg_dta, error="none")
plot(gg_dta)

# Stratified on treatment variable.
gg_dta <- gg_survival(interval="time", censor="status", 
                     data=pbc, by="treatment")
                     
plot(gg_dta, error="none")
plot(gg_dta, error="lines")
plot(gg_dta)

gg_dta <- gg_survival(interval="time", censor="status", 
                     data=pbc, by="treatment",
                     type="nelson")
                     
plot(gg_dta, error="bars")
plot(gg_dta)

}                                            
}
\seealso{
\code{\link{gg_survival}} \code{\link{nelson}} \code{\link{plot.gg_survival}}
}
