% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_stat_qc_violations.r
\name{stat_qc_violations}
\alias{stat_qc_violations}
\title{Inspect QC Violations}
\usage{
stat_qc_violations(mapping = NULL, data = NULL, geom = "point",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = FALSE, method = "xBar.rBar", geom_points = TRUE,
  geom_line = TRUE, point.size = 1.5, point.color = "black",
  violation_point.color = "red", rule.color = "darkgreen",
  line.color = NULL, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{method}{string, calling the following methods:
\itemize{
  \item \bold{Individuals Charts}: XmR,
  \item \bold{Studentized Charts}: xBar.rBar, xBar.rMedian, xBar.sBar, xMedian.rBar,
xMedian.rMedian
}}

\item{geom_points}{boolean, draw points}

\item{geom_line}{boolean, draw line}

\item{point.size}{number, size of points on chart}

\item{point.color}{string, color of points on charts (e.g., "black")}

\item{violation_point.color}{string, color of violation points on charts (e.g., "red")}

\item{rule.color}{string, color or horizontal rules indicating distribution center and sigma levels}

\item{line.color}{string, color of lines connecting points}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
faceted plot.
}
\description{
ggplot stat function that renders a faceted plot of QC violations
based on the following 4 rules:
\itemize{
\item \bold{Violation Same Side:} 8 or more consecutive, same-side points
\item \bold{Violation 1 Sigma:} 4 or more consecutive, same-side points exceeding 1 sigma
\item \bold{Violation 2 Sigma:} 2 or more consecutive, same-side points exceeding 2 sigma
\item \bold{Violation 3 Sigma:} any points exceeding 3 sigma
}
}
\examples{
#####################################
#  Example 1: XmR Check Violations  #
#####################################
# Load Libraries ----------------------------------------------------------
 require(ggQC)
 require(ggplot2)

# Setup Data --------------------------------------------------------------

    set.seed(5555)
    QC_XmR <- data.frame(
    data = c(c(-1, 2.3, 2.4, 2.5),                        #Outlier Data
          sample(c(rnorm(60),5,-5), 62, replace = FALSE), #Normal Data
          c(1,-.3, -2.4,-2.6,-2.5,-2.7, .3)),             #Outlier Data
    Run_Order = 1:73                                      #Run Order
    )


# Render QC Violation Plot ------------------------------------------------------

   EX1 <- ggplot(QC_XmR, aes(x = Run_Order, y = data)) +
     stat_qc_violations(method = "XmR")   #Makes facet graph with violations
   #EX1
#######################################
#  Example 2: Xbar Check Violations   #
#######################################

# Setup Some Data ------------------------------------------------------------
     QC_xBar.rBar <- do.call(rbind, lapply(1:3, function(X){
       set.seed(5555+X)                                   #Loop over 3 seeds
       data.frame(
         sub_group = rep(1:42),                           #Define Subgroups
         sub_class = letters[X],
         c(
          c(runif(n = 5, min = 2.0,3.2)),                 #Outlier Data
          sample(c(rnorm(30),5,-4), 32, replace = FALSE), #Normal Data
          c(runif(n = 5, min = -3.2, max = -2.0))         #Outlier Data
         )
      )
     }
   )
)

colnames(QC_xBar.rBar) <- c("sub_group","sub_class", "value")

# Render QC Violation Plot --------------------------------------------------
    EX2 <- ggplot(QC_xBar.rBar, aes(x = sub_group, y = value)) +
      stat_qc_violations(method = "xBar.rBar")
      #stat_qc_violations(method="xBar.rMedian")
      #stat_qc_violations(method="xBar.sBar")
      #stat_qc_violations(method="xMedian.rBar")
      #stat_qc_violations(method="xMedian.rMedian")
   #EX2
#######################################################
# Complete User Control - Bypass stat_qc_violation   #
#######################################################
#### The code below has two options if you are looking for complete
#### control over the look and feel of the graph. Use option 1 or option
#### 2 as appropriate. If you want something quick and easy use examples above.

##### Option 1: Setup for XmR Type Data
 # QC_XmR: Defined in Example 1
   QC_Vs <- QC_Violations(data  = QC_XmR$data, method = "XmR")
   QC_Stats <- QC_Lines(data  = QC_XmR$data, method = "XmR")
   MEAN <- QC_Stats$mean
   SIGMA <- QC_Stats$sigma

##### Option 2: Setup for xBar.rBar Type Data
 # QC_xBar.rBar: Defined in Example 2
   QC_Vs <- QC_Violations(data  = QC_xBar.rBar,
                          formula = value~sub_group,
                          method = "xBar.rBar")
   QC_Stats <- QC_Lines(data  = QC_xBar.rBar,
                        formula = value~sub_group,
                        method = "xBar.rBar")
   MEAN <- QC_Stats$xBar_Bar
   SIGMA <- QC_Stats$sigma

##### Setup second table for horizontal rules
 FacetNames <- c("Violation Same Side",
                 "Violation 1 Sigma",
                 "Violation 2 Sigma",
                 "Violation 3 Sigma")

 QC_Vs$Violation_Result <- ordered(QC_Vs$Violation_Result,
                                     levels=FacetNames)

 QC_Stats_df <- data.frame(
   Violation_Result = factor(x = FacetNames, levels = FacetNames),
   SigmaPlus = MEAN+SIGMA*0:3,
   MEAN = MEAN,
   SigmaMinus = MEAN-SIGMA*0:3
 )

##### Make the Plot
 ggplot(QC_Vs, aes(x=Index, y=data, color=Violation, group=1)) +
   geom_point() + geom_line() +
   facet_grid(.~Violation_Result) +
   geom_hline(data = QC_Stats_df, aes(yintercept = c(SigmaPlus))) +
   geom_hline(data = QC_Stats_df, aes(yintercept = c(SigmaMinus))) +
   geom_hline(data = QC_Stats_df, aes(yintercept = c(MEAN)))
}
