% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open.R
\name{git_open}
\alias{git_open}
\title{Open local repository}
\usage{
git_open(repo = ".")
}
\arguments{
\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}.}
}
\value{
an pointer to the libgit2 repository
}
\description{
Returns a pointer to a libgit2 repository object.This function is mainly
for internal use; users should simply reference a repository in gert by
by the path to the directory.
}
\examples{
r <- tempfile(pattern = "gert")
git_init(r)
r_ptr <- git_open(r)
r_ptr
git_open(r_ptr)
git_info(r)

# cleanup
unlink(r, recursive = TRUE)
}
