% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSVirtualTableParameter.R
\docType{class}
\name{GSVirtualTableParameter}
\alias{GSVirtualTableParameter}
\title{Geoserver REST API GSVirtualTableParameter}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer virtual table parameter
}
\description{
Geoserver REST API GSVirtualTableParameter
}
\section{Fields}{

\describe{
\item{\code{name}}{parameter name}

\item{\code{defaultValue}}{parameter default value}

\item{\code{regexpValidator}}{parameter regexp validator}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, name, defaultValue, regexpValidator}}{
   This method is used to instantiate a GSVirtualTableParameter
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSVirtualTableParameter from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a GSVirtualTableParameter to XML. Inherited from the
   generic \code{GSRESTResource} encoder
 }
}
}

\examples{
GSVirtualTableParameter$new(name = "fieldname", defaultValue = "default_value",
                            regexpValidator = "someregexp")

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{virtualTable}
