% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planepoint.R
\name{geo_planepoint}
\alias{geo_planepoint}
\title{Planepoint}
\usage{
geo_planepoint(point, triangle)
}
\arguments{
\item{point}{\link{Feature}<\link{Point}> the Point for which a z-value will be
calculated}

\item{triangle}{\link{Feature}<\link{Polygon}> a Polygon feature with three vertices}
}
\value{
(numeric) the z-value for \code{interpolatedPoint}
}
\description{
Takes a triangular plane as a \link{Polygon} and a \link{Point} within that
triangle and returns the z-value at that point. The Polygon needs to
have properties \code{a}, \code{b}, and \code{c} that define the values at its
three corners.
}
\examples{
point <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [-75.3221, 39.529]
  }
}'

triangle <- '{
  "type": "Feature",
  "properties": {
    "a": 11,
    "b": 122,
    "c": 44
  },
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-75.1221, 39.57],
      [-75.58, 39.18],
      [-75.97, 39.86],
      [-75.1221, 39.57]
    ]]
  }
}'

geo_planepoint(point, triangle)
}
