% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/along.R
\name{geo_along}
\alias{geo_along}
\title{Takes a \link{LineString} and returns a \link{Point} at a specified
distance along the line.}
\usage{
geo_along(line, distance, units)
}
\arguments{
\item{line}{(character) a \link{Feature}<\link{LineString}>}

\item{distance}{(numeric) distance along the line}

\item{units}{(character) can be degrees, radians, miles, or
kilometers (default)}
}
\value{
\link{Feature}<\link{Point}> distance (at X units) along the line
}
\description{
Takes a \link{LineString} and returns a \link{Point} at a specified
distance along the line.
}
\examples{
line <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "LineString",
    "coordinates": [
      [-77.031669, 38.878605],
      [-77.029609, 38.881946],
      [-77.020339, 38.884084],
      [-77.025661, 38.885821],
      [-77.021884, 38.889563],
      [-77.019824, 38.892368]
    ]
  }
}'

geo_along(line, 10, 'kilometers')
}
