% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoNodeManager.R
\docType{class}
\name{GeoNodeManager}
\alias{GeoNodeManager}
\title{GeoNode REST API Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for communication with
the REST API of a GeoNode instance.
}
\description{
GeoNode REST API Manager

GeoNode REST API Manager
}
\examples{
\dontrun{
   GeoNodeManager$new("http://localhost:8080", "user", "password")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonode}
\keyword{rest}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{verbose.info}}{if geonode4R logs have to be printed}

\item{\code{verbose.debug}}{if curl logs have to be printed}

\item{\code{loggerType}}{the type of logger}

\item{\code{url}}{the Base url of GeoNode}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GeoNodeManager-logger}{\code{GeoNodeManager$logger()}}
\item \href{#method-GeoNodeManager-INFO}{\code{GeoNodeManager$INFO()}}
\item \href{#method-GeoNodeManager-WARN}{\code{GeoNodeManager$WARN()}}
\item \href{#method-GeoNodeManager-ERROR}{\code{GeoNodeManager$ERROR()}}
\item \href{#method-GeoNodeManager-new}{\code{GeoNodeManager$new()}}
\item \href{#method-GeoNodeManager-getUrl}{\code{GeoNodeManager$getUrl()}}
\item \href{#method-GeoNodeManager-connect}{\code{GeoNodeManager$connect()}}
\item \href{#method-GeoNodeManager-getExecutionStatus}{\code{GeoNodeManager$getExecutionStatus()}}
\item \href{#method-GeoNodeManager-getCategories}{\code{GeoNodeManager$getCategories()}}
\item \href{#method-GeoNodeManager-getCategory}{\code{GeoNodeManager$getCategory()}}
\item \href{#method-GeoNodeManager-getResourceByUUID}{\code{GeoNodeManager$getResourceByUUID()}}
\item \href{#method-GeoNodeManager-getResourceByAlternate}{\code{GeoNodeManager$getResourceByAlternate()}}
\item \href{#method-GeoNodeManager-getResource}{\code{GeoNodeManager$getResource()}}
\item \href{#method-GeoNodeManager-deleteResource}{\code{GeoNodeManager$deleteResource()}}
\item \href{#method-GeoNodeManager-upload}{\code{GeoNodeManager$upload()}}
\item \href{#method-GeoNodeManager-uploadMetadata}{\code{GeoNodeManager$uploadMetadata()}}
\item \href{#method-GeoNodeManager-getDataset}{\code{GeoNodeManager$getDataset()}}
\item \href{#method-GeoNodeManager-clone}{\code{GeoNodeManager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-logger"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-logger}{}}}
\subsection{Method \code{logger()}}{
Prints a log message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$logger(type, text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{type of log, "INFO", "WARN", "ERROR"}

\item{\code{text}}{text}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-INFO"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-INFO}{}}}
\subsection{Method \code{INFO()}}{
Prints an INFO log message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$INFO(text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{text}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-WARN"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-WARN}{}}}
\subsection{Method \code{WARN()}}{
Prints an WARN log message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$WARN(text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{text}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-ERROR"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-ERROR}{}}}
\subsection{Method \code{ERROR()}}{
Prints an ERROR log message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$ERROR(text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{text}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-new}{}}}
\subsection{Method \code{new()}}{
This method is used to instantiate a GeoNodeManager with the \code{url} of the
   GeoNode and credentials to authenticate (\code{user}/\code{pwd}). 
   
   By default, the \code{logger} argument will be set to \code{NULL} (no logger). 
   This argument accepts two possible values: \code{INFO}: to print only geosapi logs,
   \code{DEBUG}: to print geosapi and CURL logs.
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the GeoNode user password with \pkg{keyring} (Default value is 'env').
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$new(url, user, pwd, logger = NULL, keyring_backend = "env")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}

\item{\code{logger}}{logger}

\item{\code{keyring_backend}}{keyring backend. Default is 'env'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-getUrl"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-getUrl}{}}}
\subsection{Method \code{getUrl()}}{
Get URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$getUrl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the Geoserver URL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-connect"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-connect}{}}}
\subsection{Method \code{connect()}}{
Connects to geoServer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$connect()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if connected, raises an error otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-getExecutionStatus"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-getExecutionStatus}{}}}
\subsection{Method \code{getExecutionStatus()}}{
Get execution status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$getExecutionStatus(execution_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{execution_id}}{the execution id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the status of execution
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-getCategories"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-getCategories}{}}}
\subsection{Method \code{getCategories()}}{
Get categories
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$getCategories(raw = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw}}{Controls the output. Default will return an object of class \link{data.frame}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-getCategory"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-getCategory}{}}}
\subsection{Method \code{getCategory()}}{
Get category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$getCategory(id, raw = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{category id}

\item{\code{raw}}{Controls the output. Default will return an object of class \link{data.frame}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-getResourceByUUID"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-getResourceByUUID}{}}}
\subsection{Method \code{getResourceByUUID()}}{
Get resource by UUID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$getResourceByUUID(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{resource uuid (or semantic id if used in place of uuid)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-getResourceByAlternate"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-getResourceByAlternate}{}}}
\subsection{Method \code{getResourceByAlternate()}}{
Get resource by Alternate
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$getResourceByAlternate(alternate)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alternate}}{resource alternate}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-getResource"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-getResource}{}}}
\subsection{Method \code{getResource()}}{
Get resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$getResource(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{resource id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-deleteResource"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-deleteResource}{}}}
\subsection{Method \code{deleteResource()}}{
Deletes a resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$deleteResource(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{resource (either a dataset or document) id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-upload"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-upload}{}}}
\subsection{Method \code{upload()}}{
Uploads resource files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$upload(files)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{files}}{files}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{list} giving the upload status
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-uploadMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-uploadMetadata}{}}}
\subsection{Method \code{uploadMetadata()}}{
Uploads ISO 19115 dataset metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$uploadMetadata(id, file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{dataset id}

\item{\code{file}}{a metadata XML file following ISO 19115 specification}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-getDataset"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-getDataset}{}}}
\subsection{Method \code{getDataset()}}{
Get dataset standardized metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$getDataset(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{dataset id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
