% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomultistar_define_geoattribute.R
\name{define_geoattribute}
\alias{define_geoattribute}
\alias{define_geoattribute.geomultistar}
\title{Define geographic attributes}
\usage{
define_geoattribute(
  gms,
  dimension = NULL,
  attribute = NULL,
  from_layer = NULL,
  by = NULL,
  from_attribute = NULL
)

\method{define_geoattribute}{geomultistar}(
  gms,
  dimension = NULL,
  attribute = NULL,
  from_layer = NULL,
  by = NULL,
  from_attribute = NULL
)
}
\arguments{
\item{gms}{A \code{geomultistar} object.}

\item{dimension}{A string, dimension name.}

\item{attribute}{A vector, attribute names.}

\item{from_layer}{A \code{sf} object.}

\item{by}{a vector of correspondence of attributes of the dimension with the
\code{sf} layer structure.}

\item{from_attribute}{A string, attribute name.}
}
\value{
A \code{geomultistar} object.
}
\description{
Defines a geographic attributes in two possible ways: Associates the
instances of attributes of the geographic dimension with the instances of a
geographic layer or defines it from the geometry of another previously
defined geographic attribute. Multiple attributes can be specified in the
\code{attribute} parameter.
}
\details{
If defined from a layer (\code{from_layer} parameter), additionally the attributes
used for the join between the tables (dimension and layer tables) must be
indicated (\code{by} parameter).

If defined from another attribute, it should have a finer granularity, to
obtain the result by grouping its instances.

If no value is indicated in the \code{attribute} parameter, it is defined for all
those attributes of the dimension that do not have any previous definition,
they are obtained from the attribute indicated in the \code{from_attribute}
parameter.
}
\examples{
library(tidyr)
library(starschemar)
library(sf)

gms <- geomultistar(ms = ms_mrs, geodimension = "where") \%>\%
  define_geoattribute(
    attribute = "city",
    from_layer = usa_cities,
    by = c("city" = "city", "state" = "state")
  )

gms <- gms \%>\%
  define_geoattribute(attribute = c("region", "all_where"),
                      from_attribute = "city")

gms <- gms \%>\%
  define_geoattribute(from_attribute = "city")

gms <- gms \%>\%
  define_geoattribute(attribute = "all_where",
                      from_layer = usa_nation)

}
\seealso{


Other geo functions: 
\code{\link{geomultistar}()},
\code{\link{get_empty_geoinstances}()},
\code{\link{run_geoquery}()}
}
\concept{geo functions}
