#' @name geometa
#' @aliases geometa-package
#' @aliases geometa
"_PACKAGE"
#' 
#' @title Tools for Reading and Writing ISO/OGC Geographic Metadata
#' 
#' @description Provides facilities to read, write and validate geographic metadata 
#' defined with ISO TC211 / OGC ISO geographic information metadata standards, and 
#' encoded using the ISO 19139 (XML) standard technical specification. This includes 
#' the following standards: ISO 19110 (Feature cataloguing), 19115 (dataset metadata),
#' 19119 (service metadata) and 19136 (GML).
#' Other interoperable schemas from the OGC are progressively supported as well, such as 
#' the Sensor Web Enablement (SWE) Common Data Model, the OGC GML Coverage Implementation 
#' Schema (GMLCOV), or the OGC GML Referenceable Grid (GMLRGRID).
#'  
#' @author Emmanuel Blondel \email{emmanuel.blondel1@@gmail.com}
#'