% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOTemporalExtent.R
\docType{class}
\name{ISOTemporalExtent}
\alias{ISOTemporalExtent}
\title{ISOTemporalExtent}
\format{\code{\link{R6Class}} object.}
\usage{
ISOTemporalExtent
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO TemporalExtent
}
\description{
ISOTemporalExtent
}
\section{Fields}{

\describe{
\item{\code{extent}}{[\code{\link{GMLTimeInstant}}|\code{\link{GMLTimePeriod}}] the temporal extent (instant or period)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOTemporalExtent}}
 }
 \item{\code{setTimeInstant(timeInstant)}}{
   Sets a time instant, object of class \code{\link{GMLTimeInstant}}
 }
 \item{\code{setTimePeriod(timePeriod)}}{
   Sets a time period, object of class \code{\link{GMLTimePeriod}}
 }
}
}

\examples{
   te <- ISOTemporalExtent$new()
   start <- ISOdate(2000, 1, 12, 12, 59, 45)
   end <- ISOdate(2010, 8, 22, 13, 12, 43)
   tp <- GMLTimePeriod$new(beginPosition = start, endPosition = end)
   te$setTimePeriod(tp)

}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{extent}
\keyword{temporal}
