% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOSpatialTemporalExtent.R
\docType{class}
\name{ISOSpatialTemporalExtent}
\alias{ISOSpatialTemporalExtent}
\title{ISOSpatialTemporalExtent}
\format{\code{\link{R6Class}} object.}
\usage{
ISOSpatialTemporalExtent
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO SpatialTemporalExtent
}
\description{
ISOSpatialTemporalExtent
}
\section{Fields}{

\describe{
\item{\code{spatialExtent}}{[\code{\link{ISOGeographicExtent}}] the geographic extent(s)}
}}

\section{Methods inherited from \code{\link{ISOTemporalExtent}}}{

\describe{
 \item{\code{setTimeInstant(timeInstant)}}{
   Sets a time instant, object of class \code{\link{GMLTimeInstant}}
 }
 \item{\code{setTimePeriod(timePeriod)}}{
   Sets a time period, object of class \code{\link{GMLTimePeriod}}
 }
}
}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOSpatialTemporalExtent}}
 }
 \item{\code{addSpatialExtent(spatialExtent)}}{
   Adds an object of class \code{\link{ISOGeographicExtent}}
 }
 \item{\code{delSpatialExtent(spatialExtent)}}{
   Deletes an object of class \code{\link{ISOGeographicExtent}}
 }
}
}

\examples{
  #create object
  md <- ISOSpatialTemporalExtent$new()
  start <- ISOdate(2000, 1, 12, 12, 59, 45)
  end <- ISOdate(2010, 8, 22, 13, 12, 43)
  tp <- GMLTimePeriod$new(beginPosition = start, endPosition = end)
  md$setTimePeriod(tp)
  spatialExtent <- ISOGeographicBoundingBox$new(minx = -180, miny = -90, maxx = 180, maxy = 90)
  md$addSpatialExtent(spatialExtent)
  
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{extent}
\keyword{spatialtemporal}
