% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOOperationMetadata.R
\docType{class}
\name{ISOOperationMetadata}
\alias{ISOOperationMetadata}
\title{ISOOperationMetadata}
\format{\code{\link{R6Class}} object.}
\usage{
ISOOperationMetadata
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOOperationMetadata
}
\description{
ISOOperationMetadata
}
\section{Fields}{

\describe{
\item{\code{dependsOn}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOOperationMetadata
 }
 \item{\code{setOperationName(operationName)}}{
   Set the operation name
 }
 \item{\code{addDCP(dcp)}}{
   Add a DCP
 }
 \item{\code{delDCP(dcp)}}{
   Deletes a DCP
 }
 \item{\code{setOperationDescription(operationDescription)}}{
   Set the operation description
 }
 \item{\code{setInvocationName(invocationName)}}{
   Set the invocation name
 }
 \item{\code{addParameter(parameter)}}{
   Add a parameter, object of class \code{ISOParameter}
 }
 \item{\code{delParameter(parameter)}}{
   Deletes a parameter, object of class \code{ISOParameter}
 }
 \item{\code{addConnectPoint(connectPoint)}}{
   Add a connect point, object of class \code{ISOOnlineResource}
 }
 \item{\code{delConnectPoint(connectPoint)}}{
   Deletes a connect point, object of class \code{ISOOnlineResource}
 }
 \item{\code{addDependentOperationMetadata(operationMetadata)}}{
   Add dependent operation metadata
 }
 \item{\code{delDependentOperationMetadata(operationMetadata)}}{
   Deletes dependent operation metadata
 }
}
}

\examples{
  md <- ISOOperationMetadata$new()
  xml <- md$encode()

}
\references{
ISO 19119:2005 - Geographic information -- Services
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{OperationMetadata}
