% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geary.R
\name{local_gearys}
\alias{local_gearys}
\title{Compute Local Geary's C}
\usage{
local_gearys(shp, adj, wts, spatial_mat)
}
\arguments{
\item{shp}{sf data frame. Optional if adj or spatial_mat provided.}

\item{adj}{zero indexed adjacency list. Optional if shp or spatial_mat provided.}

\item{wts}{Required. Numeric vector with weights to use for Moran's I.}

\item{spatial_mat}{matrix of spatial weights. Not required if shp or adj provided.}
}
\value{
numeric vector
}
\description{
Compute Local Geary's C
}
\examples{
library(dplyr)
data("checkerboard")
checkerboard <- checkerboard \%>\% mutate(m = as.numeric((id+i) \%\% 2 == 0))
local_gearys(shp = checkerboard, wts = checkerboard$m)

}
\concept{spatcorr}
