% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_download.R
\name{download_selected_files}
\alias{download_selected_files}
\title{Download selected files}
\usage{
download_selected_files(ac, subdir = NULL, unzip = TRUE, delete_zip = FALSE)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{subdir}{NULL/'year'/'area', output subdir.}

\item{unzip}{A boolean, unzip files.}

\item{delete_zip}{A boolean, delete zip files if correctly unzipped.}
}
\value{
A vector, files correctly obtained.
}
\description{
Download the files that have been selected and have not been downloaded yet,
unzip them (if desired) and, if everything went well and is indicated in the
parameter, delete the downloaded files.
}
\details{
In the \code{subdir} parameter, the values NULL, 'year' or 'area' can be indicated.
With NULL it does not create any subdirs, with 'year' it creates them by years
of downloaded files and with 'area' it creates them by areas.
}
\examples{

dir <- system.file("extdata/acs_5yr", package = "geogenr")
ac <- acs_5yr(dir)

ac <- ac |>
  select_area_files("Alaska Native Regional Corporation", 2020:2021)

files <- ac |>
  download_selected_files(unzip = FALSE)

}
\seealso{
Other data download functions: 
\code{\link{acs_5yr}()},
\code{\link{get_area_file_names}()},
\code{\link{get_area_groups}()},
\code{\link{get_area_years}()},
\code{\link{get_areas}()},
\code{\link{get_selected_file_names}()},
\code{\link{get_too_heavy_file_names}()},
\code{\link{select_area_files}()},
\code{\link{unzip_files}()}
}
\concept{data download functions}
