% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustHeight.r
\docType{methods}
\name{adjustHeight}
\alias{adjustHeight}
\alias{adjustHeight,Profile-method}
\title{Adjust Profile Height}
\usage{
adjustHeight(object, delta)

\S4method{adjustHeight}{Profile}(object, delta)
}
\arguments{
\item{object}{a single Profile.}

\item{delta}{positive or negative value.}
}
\value{
adjusted profile
}
\description{
Adjusts the height of a single profile (adds a delta value to ALL data points).
This is necessary if GPS measurement heights of two profiles differ systematically.
}
\examples{
p3 <- new(
  "Profile",
  title = "Profile 3",
  processedData =
    new("ProcessedData",
        address = system.file("extdata/processed/p3_DipolDipol_S-N.xyz",
                  package='geoelectrics')),
  rawData =
    new("RawData",
        address = system.file("extdata/raw/p3_DipolDipol_S-N.dat",
                  package='geoelectrics')),
  measurementType = "DipolDipol",
  gpsCoordinates =
    new("GpsCoordinates",
        address = system.file("extdata/gps/p3.txt",
                  package='geoelectrics'))
)

p3 <- adjustHeight(p3, -10)
}
\seealso{
\code{\link{GpsCoordinates-class}}, \code{\link{Profile-class}}
}
