% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelplotXyz.r
\name{levelplotXyzHeight}
\alias{levelplotXyzHeight}
\title{Levelplot of XYZ Data regarding Topography}
\usage{
levelplotXyzHeight(Profile, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(Profile@title, "with topography"), col = colors,
  breaks = 18, trafo = log, backtrafo = exp, ...)
}
\arguments{
\item{Profile}{profile.}

\item{xlab}{label for x-axes.}

\item{ylab}{label for y-axes.}

\item{main}{title to be plotted.}

\item{col}{vector of colors.}

\item{breaks}{number of color breaks.}

\item{trafo}{transformation to be done on data (default: log).}

\item{backtrafo}{back transformation to plot correct labels (default: exp).}

\item{...}{lattice levelplot arguments.}
}
\description{
Plots the interpolated resistance values of the 
xyz data after height adjustment.
The xyz values are obtained through inversion of the raw values.
}
\examples{
# data(sinkhole)

# levelplotXyzHeight(sinkhole@profiles[[1]])
# levelplotLegendLabel()

# levelplotXyzHeight(sinkhole@profiles[[2]])
# levelplotLegendLabel()

# levelplotXyzHeight(sinkhole@profiles[[3]])
# levelplotLegendLabel()
}
\seealso{
\code{\link{XyzData-class}}, \code{\link{levelplotXyz}},
\code{\link{levelplotRaw}}
}

