% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTerrainDerivatives.R
\name{makeTerrainDerivatives}
\alias{makeTerrainDerivatives}
\title{makeTerrainDerivatives}
\usage{
makeTerrainDerivatives(dtm, res, filename)
}
\arguments{
\item{dtm}{Input SpatRaster object representing bare earth surface elevations.}

\item{res}{Resolution of the grid relative to coordinate reference system
units (e.g., meters).}

\item{filename}{Name and full path or path relative to working directory for
output terrain stack. We recommend saving the data to either TIFF (".tif") or
Image (".img") format.}
}
\value{
Three-band raster grid written to disk in TIFF format and spatRaster object.
}
\description{
Make three band terrain stack from input digital terrain model
}
\details{
This function creates a three-band raster stack from an input digital terrain
model (DTM) of bare earth surface elevations. The first band is a topographic
position index (TPI) calculated using a moving window with a 50 m circular radius.
The second band is the square root of slope calculated in degrees. The third band
is a TPI calculated using an annulus moving window with an inner radius of 2
and outer radius of 5 meters. The TPI values are clamped to a range of -10 to 10
then linearly rescaled from 0 and 1. The square root of slope is clamped to a
range of 0 to 10 then linearly rescaled from 0 to 1. Values are provided in
floating point.

The stack is described in the following publication and was originally proposed by
William Odom of the United States Geological Survey (USGS):

Maxwell, A.E., W.E. Odom, C.M. Shobe, D.H. Doctor, M.S. Bester, and T. Ore,
2023. Exploring the influence of input feature space on CNN-based geomorphic
feature extraction from digital terrain data, Earth and Space Science,
10: e2023EA002845. https://doi.org/10.1029/2023EA002845.
}
\examples{
\dontrun{
inDTM <- terra::rast("INPUT DTM NAME AND PATH")
terrOut <- makeTerrainDerivatives(dtm=inDTM,
                                 res=2,
                                 filename="OUT TERRAIN STACK NAME AND PATH")
}
}
