% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfd.R
\name{sfd}
\alias{sfd}
\title{Calculate the fractal dimension of a raster.}
\usage{
sfd(x, silent = FALSE)
}
\arguments{
\item{x}{A raster or matrix.}

\item{silent}{Logical. If \code{FALSE} (default), the function will
print warning messages.}
}
\value{
A numeric value representing the fractal dimension of
the image.
}
\description{
Calculates the 3D fractal dimension of a raster using the
triangular prism surface area method.
}
\examples{

# import raster image
data(normforest)

# calculate the fractal dimension
Sfd <- sfd(normforest)
}
\references{
Clarke, K.C., 1986. Computation of the fractal dimension
of topographic surfaces using the triangular prism surface area method.
Computers & Geosciences, 12(5), pp.713-722.
}
