% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolevel.R
\name{geolevel}
\alias{geolevel}
\title{\code{geolevel} S3 class}
\usage{
geolevel(name = NULL, layer = NULL, attributes = NULL, key = NULL)
}
\arguments{
\item{name}{A string, level name.}

\item{layer}{A \code{sf} object.}

\item{attributes}{A vector, selected attributes.}

\item{key}{A vector, attributes that compose the key.}
}
\value{
A \code{geolevel} object.
}
\description{
A \code{geolevel} object is created from a given geographic layer. The attributes
of the layer to be included in the level can be indicated, and the subset of
these that make up the natural key. If no attribute is indicated, all are
considered. In any case, the attributes that make up the key must be
indicated.
}
\details{
A level can have several associated geometries (point, polygon or line). The
geometry is obtained from the layer data.

The name of the level is used later to reference it and relate it to other
levels.
}
\examples{
library(sf)

region <-
  geolevel(name = "region",
           layer = layer_us_region,
           key = c("geoid"))

}
\seealso{


Other level definition functions: 
\code{\link{add_geometry}()},
\code{\link{check_key}()},
\code{\link{complete_point_geometry}()},
\code{\link{coordinates_to_geometry}()},
\code{\link{get_empty_geometry_instances}()},
\code{\link{get_geometry}()}
}
\concept{level definition functions}
