% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cf_dens.R
\name{get_cf_dens}
\alias{get_cf_dens}
\title{Get counterfactual densities}
\usage{
get_cf_dens(expected_number, base_dens, power_dens = NA, window)
}
\arguments{
\item{expected_number}{the expected number of observations.}

\item{base_dens}{baseline density (im object)}

\item{power_dens}{power density (im object)}

\item{window}{owin object}
}
\value{
an im object of a counterfactual density
}
\description{
`get_cf_dens` takes the target (expected) number, baseline density,
and power density, and generates a hyperframe with counterfactual densities.
}
\details{
There are two ways of generating counterfactual densities.
First, users can keep the locations of observations as they are and change the expected number of observations.
In this case, users do not have to set `power_dens` and simply modify `expected_number`.
Alternatively, users can shift the locations as well. In this case, `power_dens` must be specified.
To obtain power densities, refer to [get_power_dens()].
}
