% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_replace.R
\name{split_replace}
\alias{split_replace}
\title{Splits a Raster* object into smaller chunks and allows to replace cell values}
\usage{
split_replace(raster, partPerSide, h, v, outputPath, name, save = TRUE,
  replace = FALSE, valToReplace, replacedBy, dataType,
  format = "GTiff", parallelProcessing = FALSE, numCores = 20,
  cellsToProcess, ...)
}
\arguments{
\item{raster}{Raster* object.}

\item{partPerSide}{integer indicating number of cells in which \code{raster} will be split 
in each direction (horizontally and vertically). Use when \code{nrow(raster)} and 
\code{ncol(raster)} are multiples of \code{partPerSide}.}

\item{h}{integer indicating number of horizontal cells in which \code{raster} will be split.}

\item{v}{integer indicating number of vertical cells in which \code{raster} will be split.}

\item{outputPath}{character with full path name where the resulting Raster* objects will be saved.}

\item{name}{character with the name to assign to final products.}

\item{save}{logical, should the output be saved, default is \code{TRUE}.}

\item{replace}{logical, default \code{FALSE}, when \code{TRUE}, \code{valToReplace} and \code{replacedBy} must by specified.}

\item{valToReplace}{indicates a value to be replaced across \code{raster} cells.}

\item{replacedBy}{indicates the value by which \code{valToReplace} is replaced.}

\item{dataType}{character, output data type. See \code{\link[raster]{dataType}}.}

\item{format}{character, output file type, default \code{"GTiff"}. See \code{\link[raster]{writeFormats}}.}

\item{parallelProcessing}{logical, default \code{FALSE}, when \code{TRUE} raster splitting is done in parallel. See
\code{details}.}

\item{numCores}{numeric indicating the number of cores used in parallel processing.}

\item{cellsToProcess}{numeric vector indicating which smaller cells should be processed/saved. See \code{details}.}

\item{...}{additional arguments used by \code{\link[raster]{writeRaster}}.}
}
\value{
At \code{outputPath} the user will find \code{length(cellsToProcess)} Raster* files
}
\description{
This function will split a Raster* object into smaller chunks. The size of these chunks (number of cells) 
is controlled by \code{partPerSide}, \code{h} or \code{v}. Additionally, it allows to replace cell values (\code{valToReplace}) 
within Raster* object by another value of user's choice (\code{replacedBy}). When \code{save = TRUE}, 
the resulting \code{cellsToProcess} Raster* objects are saved in directory \code{outputPath}.
}
\details{
Before processing any of the \code{cellsToProcess} the temporary raster 
directory is re-directed. Basically, prior to process the i-th cell, 
at \code{outputPath} a new subdirectory is created, which, in turn, is erased 
automatically once the i-th cell has been processed. As a result of several tests 
we found that this measure avoids memory overflow.

When \code{partPerSide} is used, \code{cellsToProcess = 1:(partPerSide^2)}. When \code{h}
and \code{v} are used, \code{cellsToProcess = 1:(ncells(raster)/(h*v))}. Since the code
assumes that \code{nrow(raster)} and \code{ncol(raster)} are multiples of \code{partPerSide}
or \code{h} and \code{v}, respectively, the user must be careful when selecting these
parameters.

For \code{parallelProcessing} the backend \code{\link[doParallel]{doParallel}} is employed.
}
\seealso{
\code{\link[raster]{writeRaster}}, \code{\link[raster]{aggregate}}, 
\code{\link[raster]{rasterOptions}}
}
