% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/linear_ss_function_linear_environment_interaction.R
\name{ss_linear_envir.calc.linear_outcome}
\alias{ss_linear_envir.calc.linear_outcome}
\title{Function to Calculate Power for Linear Models with linear environment interaction}
\usage{
ss_linear_envir.calc.linear_outcome(
  pow = NULL,
  MAF = NULL,
  ES_G = NULL,
  ES_E = NULL,
  ES_GE = NULL,
  sd_e = NULL,
  R2_G = NULL,
  R2_E = NULL,
  R2_GE = NULL,
  sd_y = NULL,
  Alpha = 0.05,
  True.Model = "All",
  Test.Model = "All"
)
}
\arguments{
\item{pow}{Vector of the desired power(s)}

\item{MAF}{Vector of minor allele frequencies}

\item{ES_G}{Vector of genetic effect sizes (difference in means) to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{ES_E}{Vector of environmental effect sizes (difference in means) to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{ES_GE}{Vector of genetic/environment interaction effect sizes (difference in means) to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{sd_e}{Standard deviation of the environmental variable}

\item{R2_G}{Vector of genetic R-squared values to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{R2_E}{Vector of environmental R-squared values to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{R2_GE}{Vector of genetic/environment interaction R-squared values to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{sd_y}{Standard deviation of the outcome in the population (ignoring genotype). Either sd_y_x or sd_y must be specified.}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the power for all combinations of the specified parameters (Case.Rate, ES, Power, etc)
}
\description{
Calculates the power to detect an difference in means/effect size/regression coefficient, at a given sample size, N, with type 1 error rate, Alpha
}
\examples{
ss_linear_envir.calc.linear_outcome(pow = 0.8, 
	ES_G=0.5, ES_E=1.6, ES_GE=1.4, 
	sd_e = 1, MAF=0.28, 
	sd_y = 5,Alpha=0.05,
	True.Model='All', Test.Model='All')

}
