% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2qtl_table.R
\name{convert2qtl_table}
\alias{convert2qtl_table}
\title{write out table for import into rqtl}
\usage{
convert2qtl_table(genotypeR_object,
  temp_cross_for_qtl = "temp_cross_for_qtl.csv", chromosome_vect = NULL)
}
\arguments{
\item{genotypeR_object}{this is a genotypeR object that has had
genotypes coded as binary with binary_coding}

\item{temp_cross_for_qtl}{name of the output file that will be output
into the working directory}

\item{chromosome_vect}{this is a vector of marker chromosome
the length of the markers}
}
\value{
table to disk for input into rqtl
}
\description{
\code{convert2qtl_table} will take a genotypeR object that
contains binary coded genotypes, and export this to a csv
file suitable for use with Rqtl.
}
\examples{

data(genotypes_data)
data(markers)
## genotype table
marker_names <- make_marker_names(markers)
GT_table <- Ref_Alt_Table(marker_names)
## remove those markers that did not work
genotypes_data_filtered <- genotypes_data[,c(1, 2, grep("TRUE",
colnames(genotypes_data)\%in\%GT_table$marker_names))]

warnings_out2NA <- initialize_genotypeR_data(seq_data = genotypes_data_filtered,
genotype_table = GT_table, output = "warnings2NA")
binary_coding_genotypes <- binary_coding(warnings_out2NA, genotype_table = GT_table)
chr2 <- subsetChromosome(binary_coding_genotypes, chromosome="chr2")
count_CO <- count_CO(chr2)
convert2qtl_table(count_CO, paste(temp_cross_for_qtl=getwd(),
"test_temp_cross.csv", sep="/"),
chromosome_vect=rep("2", (length(colnames(binary_genotypes(count_CO)))-2)))


}
\keyword{genotypeR,}
\keyword{rqtl}
