% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_plots.R
\name{error_bar_plot}
\alias{error_bar_plot}
\title{Plot log likelihoods of profiles with approximate confidence intervals}
\usage{
error_bar_plot(data)
}
\arguments{
\item{data}{The output from the \code{genogeo} function}
}
\value{
A barplot of the log likelihoods for each population with confidence limits
}
\description{
Plots the estimated profile probabilities in each population.
The colour depends on the profiles likelihood and rejection/acceptance (blue/red) based on z-score
}
\examples{
df_ <- simulate_pops(pop_n = 20, aims_n = 50)
df_db <- pops_to_DB(df_)
profile <- random_AIMs_profile(df_db, keep_pop = TRUE)
profile$pop[1] # The true population
result <- genogeo(profile[,c("locus","x0")], df = df_db)
error_bar_plot(result)
}
\author{
Torben Tvedebrink, \email{tvede@math.aau.dk}
}
