% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{genedivFis}
\alias{genedivFis}
\title{Gene diversities and Fis (or rho_IS)}
\usage{
genedivFis(
  inputFile,
  sizes = FALSE,
  outputFile = "",
  dataType = "Diploid",
  verbose = interactive()
)
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{sizes}{logical: whether to compute statistics based on allele size, or not.}

\item{outputFile}{character: The path of the output file}

\item{dataType}{character: The haploid and diploid data}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Evaluates Fis and gene diversities, or related measures based on allele sizes. See \href{../doc/all-menu-options.html#sub-option-2-identity-based-gene-diversities-and-f_mathrmis}{this section} of the Genepop executable documentation for more information on the identity-based statistical methods, and \href{../doc/all-menu-options.html#sub-option-3-allele-size-based-gene-diversities-and-rho_mathrmis}{this one} for allele-size based ones.
}
\examples{
locinfile <- genepopExample('sample.txt')
genedivFis(locinfile,outputFile = 'sample.txt.DIV')
if ( ! interactive()) clean_workdir(otherfiles='sample.txt')
}
