% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table2hap.R
\name{table2hap}
\alias{table2hap}
\title{table2hap}
\usage{
table2hap(x, hapPrefix = "H", hyb_remove = TRUE, na.drop = TRUE)
}
\arguments{
\item{x}{a data.frame contains variants information.
The first four column are fix as Chrome name, position, reference nuclieotide
and alter nuclieotide. Accession genotype should be in followed columns.
"-" will be treated as Indel. "." and "N" will be treated as missing data.
Heterozygotes should be "A/T", "AAA/A"}

\item{hapPrefix}{prefix of haplotype names}

\item{hyb_remove}{whether remove accessions contains hyb-sites, Character not A T C G}

\item{na.drop}{whether drop accessions contains missing data ("N", "NA", ".")}
}
\value{
object of hapSummary class
}
\description{
convert variants stored in table format into hapResult
}
\examples{
\donttest{
   data("geneHapR_test")
   hapResult <- table2hap(gt.geno, hapPrefix = "H",
                          hyb_remove = TRUE,
                          na.drop = TRUE)
}
}
